####################################################
### code chunk number : Simulations: Two inequalities, Given (alpha, beta, x_np1)
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 3
beta = 2
x_np1 = 1

# set.seed(1) 
# theta_np1 = 1 / rgamma(n = 1, shape = alpha, scale = 1 / beta); theta_np1
# x_np1 = rexp(n = 1, rate = 1 / theta_np1); x_np1

res = Compute_PostDist_Estimators_PESLs(x_np1, alpha, beta); res[2:5]

dev.new()
## xlim = c(0, 1)
xlim = range(res$PostDist_theta)
ylim = c(0, 1.3)
hist(res$PostDist_theta, freq = FALSE, breaks = 100, 
     xlab = expression(paste(theta[n+1], "|", x[n+1])), 
     ylab = expression( pi(paste(theta[n+1], "|", x[n+1]))), 
     main = expression(paste("Histogram of ", theta[n+1], "|", x[n+1])), 
     xlim = xlim, 
     ylim = ylim) 
lines(density(res$PostDist_theta), lty = 1, col = c('blue'), lwd = 4)
leg.txt = c("Density estimation curve")
legend("topright", legend = leg.txt, lty = 1, col = c('blue'), lwd = 2)
savePlot(filename = "figure/Exp-IG_Density_estimation_curve", type = c("pdf"))
savePlot(filename = "figure/Exp-IG_Density_estimation_curve", type = c("jpg"))


####################################################
### code chunk number : Simulations: Two inequalities, alpha changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 1:10; alpha
beta = 2
x_np1 = 1
L_alpha = length(alpha); L_alpha

delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_alpha)
for (i in 1:L_alpha){
	res_i = Compute_Estimators_PESLs(x_np1, alpha[i], beta)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4); B
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = alpha, para_name = "alpha", xlab = expression(alpha), legend_pos = "topright", sub = "(a)")
plot_PESL(PESL_s, PESL_2, parameter = alpha, para_name = "alpha", xlab = expression(alpha), legend_pos = "topright", sub = "(b)")


####################################################
### code chunk number : Simulations: Two inequalities, beta changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 3
beta = 1:10; beta
x_np1 = 1
L_beta = length(beta); L_beta

delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_beta)
for (i in 1:L_beta){
	res_i = Compute_Estimators_PESLs(x_np1, alpha, beta[i])
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4); B
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = beta, para_name = "beta", xlab = expression(beta), legend_pos = "topleft", sub = "(c)")
plot_PESL(PESL_s, PESL_2, parameter = beta, para_name = "beta", xlab = expression(beta), legend_pos = "right", sub = "(d)")


####################################################
### code chunk number : Simulations: Two inequalities, x changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 3
beta = 2
x_np1 = 1:10; x_np1
L_x = length(x_np1); L_x

delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_x)
for (i in 1:L_x){
	res_i = Compute_Estimators_PESLs(x_np1[i], alpha, beta)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = x_np1, para_name = "x", xlab = expression(x[n+1]), legend_pos = "topleft", sub = "(e)")
plot_PESL(PESL_s, PESL_2, parameter = x_np1, para_name = "x", xlab = expression(x[n+1]), legend_pos = "right", sub = "(f)")


####################################################
### code chunk number : Simulations: Two inequalities, persp3d
####################################################
## 
## delta_s <= delta_2 
## PESL_s <= PESL_2 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(rgl) ## Install the R package rgl first.
# install.packages(pkgs = "rgl", repos = "https://cloud.r-project.org/", dependencies=TRUE)
# install.packages(pkgs = "shiny", repos = "https://cloud.r-project.org/", dependencies=TRUE)
a = seq(1.1, 10, length = 20); L_a = length(a); L_a
b = seq(0.1, 10, length = 20); L_b = length(b); L_b

delta_s  = function(a, b){ b/a }
delta_2 = function(a, b){ b/(a-1) }
PESL_s= function(a, b){ log(a) - digamma(a) }
PESL_2= function(a, b){ 1/(a - 1) + log(a - 1) - digamma(a) }

delta_2_s = function(a, b){ delta_2(a, b) - delta_s(a, b) }
PESL_2_s = function(a, b){ PESL_2(a, b) - PESL_s(a, b) }

## 
## Estimators
## 
z_delta_s = outer(a, b, FUN = "delta_s")
range(z_delta_s)
dim(z_delta_s)

z_delta_2 = outer(a, b, FUN = "delta_2")
range(z_delta_2)
dim(z_delta_2)

range(z_delta_2 - z_delta_s)

z_delta_2_s = outer(a, b, FUN = "delta_2_s")
range(z_delta_2_s)

open3d()
persp3d(a, b, z_delta_2, col = "red", xlab = "a", ylab = "b", zlab = "Estimator")
persp3d(a, b, z_delta_s, col = "blue", add = TRUE)
rgl.postscript("figure/Estimators.pdf", "pdf")

open3d()
persp3d(a, b, z_delta_2_s,  col = "green", xlab = "a", ylab = "b", zlab = "delta[2](x) - delta[s](x)")
rgl.postscript("figure/delta_2_s.pdf", "pdf")

## 
## PESLs
## 
z_PESL_2 = outer(a, b, FUN = "PESL_2")
range(z_PESL_2)
dim(z_PESL_2)

z_PESL_s = outer(a, b, FUN = "PESL_s")
range(z_PESL_s)
dim(z_PESL_s)

range(z_PESL_2 - z_PESL_s)

z_PESL_2_s = outer(a, b, FUN = "PESL_2_s")
range(z_PESL_2_s)

open3d()
persp3d(a, b, z_PESL_2, col = "red", xlab = "a", ylab = "b", zlab = "PESL")
persp3d(a, b, z_PESL_s, col = "blue", add = TRUE)
rgl.postscript("figure/PESLs.pdf", "pdf")

open3d()
persp3d(a, b, z_PESL_2_s, col = "green", xlab = "a", ylab = "b", zlab = "PESL[2](x) - PESL[s](x)")
rgl.postscript("figure/PESL_2_s.pdf", "pdf")


